-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

--- Änderungsmanagement

--- Eigenschaften / Parameter Anfang
SELECT TSystem.trigger__disable( 'recnogroup' );

--- Vorgaben
INSERT INTO recnogroup (reg_schema, reg_tablename,        reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname,          reg_exclusive, reg_autoinsert, reg_visible)
                VALUES ('tartikel', 'beleg_k__artchange', 26456,             10,      26334,          'ptENUM',      'k_artc.art',       true,          false,          true       ); --Art / Klassifizierung

INSERT INTO recnogroup (reg_schema, reg_tablename,        reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname,          reg_exclusive, reg_autoinsert, reg_visible)
                VALUES ('tartikel', 'beleg_k__artchange', 26456,             20,      17618,          'ptENUM',      'k_artc.kategorie', true,          false,          true       ); --Kategorie

INSERT INTO recnogroup(reg_schema, reg_tablename,         reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname,          reg_exclusive, reg_autoinsert, reg_visible)
                VALUES('tartikel', 'beleg_k__artchange',  26456,             30,      3901,           'ptENUM',      'k_artc.prio',      true,          false,          true       ); --Priorität

INSERT INTO recnogroup(reg_schema, reg_tablename,         reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname,          reg_exclusive, reg_autoinsert, reg_visible)
                VALUES('tartikel', 'beleg_k__artchange',  26456,             40,      734,            'ptENUM',      'k_artc.stat',      true,          false,          true       ); --Status

INSERT INTO recnogroup(reg_schema, reg_tablename,         reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname,          reg_exclusive, reg_autoinsert, reg_visible)
                VALUES('tartikel', 'beleg_k__artchange',  26456,             50,      216,            'ptENUM',      'k_artc.abt',       true,          false,          true       ); --Abteilung

INSERT INTO recnogroup(reg_schema, reg_tablename,         reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname,          reg_exclusive, reg_autoinsert, reg_visible)
                VALUES('tartikel', 'beleg_k__artchange',  26456,             60,      26353,          'ptENUM',      'k_artc.fb',        true,          false,          true       ); --Fachbereich

--- Tabelle 'Enums'

CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;
--- Art / Klassifizierung
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.art', 'R', 'Antrag',     nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.art', 'O', 'Auftrag',    nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.art', 'N', 'Mitteilung', nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

--- Kategorie
CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.kategorie', 'K', 'für Kunde',               nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.kategorie', 'E', 'Eigeninitiative',         nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.kategorie', 'Q', 'Qualitätsprobleme',       nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.kategorie', 'P', 'Neue Produktionsmethode', nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.kategorie', 'X', 'Icks',                    nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

--- Priorität
CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.prio', '1', 'Niedrig', nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.prio', '2', 'Mittel',  nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.prio', '3', 'Hoch',    nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

--- Status
CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.stat', 'N', 'Neu',            nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.stat', 'B', 'in Bearbeitung', nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.stat', 'F', 'Freigegeben',    nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.stat', 'A', 'Abgeschlossen',  nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

--- Abteilung
CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.abt', 'ME', 'Mechanik',            nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.abt', 'SA', 'Säge',                nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.abt', 'EK', 'Einkauf',             nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.abt', 'AV', 'Arbeitsvorbereitung', nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.abt', 'EN', 'Entwicklung',         nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.abt', 'MO', 'Montage',             nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

--- Fachbereich
CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.fb', 'MQS',  'Mechanik QS', nextval('seq_rege_pos'));
INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.fb', 'VERT', 'Vertrieb',    nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;


--- Bewertung
INSERT INTO recnogroup (reg_bez, reg_gruppe, reg_ac_n, reg_pname            , reg_gruppe_textno, reg_bez_textno, reg_paramtype, reg_visible, reg_exclusive, reg_schema, reg_tablename       , reg_autoinsert, reg_pos, reg_m_iso)
VALUES (                null   , NULL      , NULL    , 'k_artc.auswirkungen', 1601             , 26387         , 'ptENUM'     , true       , false        , 'tartikel', 'beleg_k__artchange', true          , 40     , NULL);

INSERT INTO recnogroup (reg_bez, reg_gruppe, reg_ac_n, reg_pname            , reg_gruppe_textno, reg_bez_textno, reg_paramtype, reg_visible, reg_exclusive, reg_schema, reg_tablename       , reg_autoinsert, reg_pos, reg_m_iso)
VALUES (                null   , NULL      , NULL    , 'k_artc.bereiche'    , 1601             , 26384         , 'ptENUM'     , true       , false        , 'tartikel', 'beleg_k__artchange', true          , 10     , NULL);

INSERT INTO recnogroup (reg_bez, reg_gruppe, reg_ac_n, reg_pname            , reg_gruppe_textno, reg_bez_textno, reg_paramtype, reg_visible, reg_exclusive, reg_schema, reg_tablename       , reg_autoinsert, reg_pos, reg_m_iso)
VALUES (                null   , NULL      , NULL    , 'k_artc.einstufung'  , 1601             , 26386         , 'ptENUM'     , true       , false        , 'tartikel', 'beleg_k__artchange', true          , 30     , NULL);

INSERT INTO recnogroup (reg_bez, reg_gruppe, reg_ac_n, reg_pname            , reg_gruppe_textno, reg_bez_textno, reg_paramtype, reg_visible, reg_exclusive, reg_schema, reg_tablename       , reg_autoinsert, reg_pos, reg_m_iso)
VALUES (                null   , NULL      , NULL    , 'k_artc.gremium'     , 1601             , 26385         , 'ptENUM'     , true       , false        , 'tartikel', 'beleg_k__artchange', true          , 20     , NULL);

--- Tabelle 'Enums'
CREATE SEQUENCE  seq_rege_pos START 1;
--- Auswirkung
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'ASK', 'Auswirkung auf ASK' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'BM', 'Auswirkung auf Betriebsmittel' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'Lag', 'Auswirkung auf Lagerbestände' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'Fert', 'Auswirkung auf laufende Fertigung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'NC', 'Auswirkung auf NC Programme' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'QM', 'Auswirkung auf QM-Dokumente' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'Lief', 'Auswirkungen auf Lieferanten / Lieferantenqualifizierung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.auswirkungen', 'MM', 'Auswirkungen auf Messmittel' , nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;
---
--- Einstufung
CREATE SEQUENCE  seq_rege_pos START 1;
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'ABK', 'ABK - Fehler' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'BM', 'Betriebsmittel ungeeignet' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'HM', 'Hilfsmittel ungeeignet' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'Mat', 'Material ungeeignet' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'NA', 'Nacharbeit erforderlich' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'Prf', 'Prüfung nicht möglich' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'QM', 'QM - Dokumente müssen angepasst werden' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.einstufung', 'Rep', 'Reparatur erforderlich' , nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;
---
--- Bereiche
CREATE SEQUENCE  seq_rege_pos START 1;
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.bereiche', 'PR', 'Produktion' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.bereiche', 'QS', 'Qualitätssicherung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.bereiche', 'AV', 'Arbeitsvorbereitung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.bereiche', 'EN', 'Entwicklung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.bereiche', 'EK', 'Einkauf' , nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

--- Gremium
CREATE SEQUENCE  seq_rege_pos START 1;
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.gremium', 'PR', 'Leiter Produktion' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.gremium', 'QS', 'Leiter Qualitätssicherung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.gremium', 'AV', 'Leiter Arbeitsvorbereitung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.gremium', 'EN', 'Leiter Entwicklung' , nextval('seq_rege_pos'));
INSERT INTO recnoenums  (rege_reg_pname, rege_code, rege_bez, rege_pos) VALUES('k_artc.gremium', 'EK', 'Leiter Einkauf' , nextval('seq_rege_pos'));
DROP SEQUENCE seq_rege_pos;

   --- #12675 PK-Auswertung
   INSERT INTO RecNoGroup(reg_tablename, reg_pos, reg_pname                      , reg_gruppe_textno, reg_bez_textno, reg_paramtype, reg_autoinsert)
   VALUES                ('abk'        ,      10, 'ABK.PK-Auswertung.Abteilung'  ,             26452,            216, 'ptENUM'     , true),
                         ('abk'        ,      20, 'ABK.PK-Auswertung.Begruendung',             26452,          26453, 'ptENUM'     , true);

   INSERT INTO recnoenums(rege_reg_pname               , rege_pos, rege_code, rege_bez)
   VALUES                ('ABK.PK-Auswertung.Abteilung',       10, 'ABFR'   , 'Airbus-Rfäserei'),
                         ('ABK.PK-Auswertung.Abteilung',       20, 'AUSB'   , 'Ausbildung'),
                         ('ABK.PK-Auswertung.Abteilung',       30, 'ASWV'   , 'Auswärtsvergabe'),
                         ('ABK.PK-Auswertung.Abteilung',       40, 'AV'     , 'AV'),
                         ('ABK.PK-Auswertung.Abteilung',       50, 'DMFG'   , 'DMF-Gruppe'),
                         ('ABK.PK-Auswertung.Abteilung',       60, 'DRE'    , 'Dreherei'),
                         ('ABK.PK-Auswertung.Abteilung',       70, 'ERDN'   , 'Erodieren'),
                         ('ABK.PK-Auswertung.Abteilung',       80, 'FIN'    , 'Finisch'),
                         ('ABK.PK-Auswertung.Abteilung',       90, 'FRH3'   , 'Fräserei H3'),
                         ('ABK.PK-Auswertung.Abteilung',      100, 'FRH4'   , 'Fräserei H4'),
                         ('ABK.PK-Auswertung.Abteilung',      110, 'LIEF'   , 'Lieferant'),
                         ('ABK.PK-Auswertung.Abteilung',      120, 'KONST'  , 'Konstruktion/Vorr.'),
                         ('ABK.PK-Auswertung.Abteilung',      130, 'KONTR'  , 'Kontrolle'),
                         ('ABK.PK-Auswertung.Abteilung',      140, 'MATER'  , 'Material'),
                         ('ABK.PK-Auswertung.Abteilung',      150, 'MLTG'   , 'Multus-Gruppe'),
                         ('ABK.PK-Auswertung.Abteilung',      160, 'NMVG'   , 'NMV-Gruppe'),
                         ('ABK.PK-Auswertung.Abteilung',      170, 'PROGR'  , 'Programmierung'),
                         ('ABK.PK-Auswertung.Abteilung',      180, 'SCHL'   , 'Schleifen'),
                         ('ABK.PK-Auswertung.Abteilung',      190, 'VATG'   , 'VAT-Gruppe'),
                         ('ABK.PK-Auswertung.Abteilung',      200, 'VERTR'  , 'Vertrieb'),
                         ('ABK.PK-Auswertung.Abteilung',      210, 'WFLG'   , 'WFL-Gruppe');

   INSERT INTO recnoenums(rege_reg_pname                 , rege_pos, rege_code, rege_bez)
   VALUES                ('ABK.PK-Auswertung.Begruendung',       10, 'AZBA'   , 'Azubi-Arbeit'),
                         ('ABK.PK-Auswertung.Begruendung',       20, 'FALKS'  , 'Falsche/zu teure Kostenstelle'),
                         ('ABK.PK-Auswertung.Begruendung',       30, 'AUS'    , 'Ausschuss'),
                         ('ABK.PK-Auswertung.Begruendung',       40, 'KWIRT'  , 'Keine wirtsch. Fertigungsmöglichkeit'),
                         ('ABK.PK-Auswertung.Begruendung',       50, 'MAT'    , 'Material'),
                         ('ABK.PK-Auswertung.Begruendung',       60, 'MADEF'  , 'Maschine defekt'),
                         ('ABK.PK-Auswertung.Begruendung',       70, 'VERED'  , 'Veredelung/Öberfläche'),
                         ('ABK.PK-Auswertung.Begruendung',       80, 'FERTO'  , 'Fertigungsoptimierung'),
                         ('ABK.PK-Auswertung.Begruendung',       90, 'AUFSP'  , 'Aufspannung / Vorrichtung'),
                         ('ABK.PK-Auswertung.Begruendung',      100, 'KOMM'   , 'Kommunikation'),
                         ('ABK.PK-Auswertung.Begruendung',      110, 'DIVER'  , 'Diverse');

SELECT TSystem.trigger__enable( 'recnogroup' );

--- Eigenschaften / Parameter Ende

---
DO $$               --- Änderungsverwaltung
 DECLARE
    k_id_       INTEGER;
    p_aknr            VARCHAR;
    p_aknr_       VARCHAR;
    partc_aknr_neu_   VARCHAR;
    p_ak_bez_       VARCHAR;
    partc_strrevnr_alt_ VARCHAR;

    ks_abt          VARCHAR :='GLU-001';
 BEGIN

  INSERT INTO tartikel.beleg_k__artchange
  (k_kba_key,
   k_code,
   k_nummer,
   k_titel,
   k_erfasst_datum,
   k_ad_krz,
   x_allgv1,
   kartc_x_artcv_key_kategorie,
   kartc_antrag_db_usename,
   kartc_antrag_ks_abt,
   kartc_x_artcv_key_abt,
   kartc_x_artcv_key_prio,
   kartc_serie,
   kartc_txt_beschreibung,
   kartc_txt_grund,
   kartc_x_artcv_key_fb,
   kartc_x_artcv_key_stat,
   kartc_datum_gueltigab,
   kartc_sernr_ab,
   kartc_abschluss_db_usename
   )
  VALUES
   (
   'NT',          --- k_kba_key
   'O',           --- k_code
   getnumcirclenr('beleg_k__artchange'),        --- k_nummer
   'Test',          --- k_titel
   current_date,        --- k_erfasst_datum
   '#',           --- k_ad_krz
   'param1',          --- x_allgv1
   'Q',           --- kartc_x_artcv_key_kategorie
   current_user,        --- kartc_antrag_db_usename
   ks_abt,          --- kartc_antrag_ks_abt
   'ME',          --- kartc_x_artcv_key_abt
   '2',           --- kartc_x_artcv_key_prio
   'Serie',           --- kartc_serie
   'Beschreibungstext',       --- kartc_txt_beschreibung
   'Änderungstext',       --- kartc_txt_grund
   'MQS',           --- kartc_x_artcv_key_fb
   'B',           --- kartc_x_artcv_key_stat
   current_date + 15,         --- kartc_datum_gueltigab
   '0022',          --- kartc_sernr_ab
   current_user         --- kartc_abschluss_db_usename
  ) RETURNING k_id INTO k_id_;


  p_aknr_ := 'G.PKW.A-1168534 /A';
  SELECT ak_bez INTO p_ak_bez_ FROM art WHERE ak_nr = p_aknr_;
  partc_aknr_neu_ := null;
  partc_strrevnr_alt_ := 'R1';
  INSERT INTO tartikel.beleg_p__artchange
    (p_k_id, p_erfasst_datum, p_pos, p_apint_db_usename, p_aknr , p_ak_bez , partc_aknr_neu /*, partc_strrevnr_alt*/)
   VALUES
    (k_id_ , current_date   , 10   , current_user      , p_aknr_, p_ak_bez_, partc_aknr_neu_/*, partc_strrevnr_alt_*/);

  p_aknr_ := 'E.B.PKW.A-1168534-0100 /A';
  SELECT ak_bez INTO p_ak_bez_ FROM art WHERE ak_nr = p_aknr_;
  partc_aknr_neu_ := 'E.B.PKW.A-1168534-0001 /A';
  partc_strrevnr_alt_ := 'Aktuell';
  INSERT INTO tartikel.beleg_p__artchange
    (p_k_id, p_erfasst_datum, p_pos, p_apint_db_usename, p_aknr , p_ak_bez , partc_aknr_neu /*, partc_strrevnr_alt*/)
   VALUES
    (k_id_ , current_date   , 20   , current_user      , p_aknr_, p_ak_bez_, partc_aknr_neu_/*, partc_strrevnr_alt_*/);

  p_aknr_ := 'AW.0010';
  SELECT ak_bez INTO p_ak_bez_ FROM art WHERE ak_nr = p_aknr_;
  partc_aknr_neu_ := null;
  partc_strrevnr_alt_ := 'Aktuell';
  INSERT INTO tartikel.beleg_p__artchange
    (p_k_id, p_erfasst_datum, p_pos, p_apint_db_usename, p_aknr , p_ak_bez , partc_aknr_neu /*, partc_strrevnr_alt*/)
   VALUES
    (k_id_ , current_date   , 30   , current_user      , p_aknr_, p_ak_bez_, partc_aknr_neu_/*, partc_strrevnr_alt_*/);
---

  INSERT INTO tartikel.beleg_k__artchange
  (k_kba_key,
   k_code,
   k_nummer,
   k_titel,
   k_erfasst_datum,
   k_ad_krz,
   x_allgv1,
   kartc_x_artcv_key_kategorie,
   kartc_antrag_db_usename,
   kartc_antrag_ks_abt,
   kartc_x_artcv_key_abt,
   kartc_x_artcv_key_prio,
   kartc_serie,
   kartc_txt_beschreibung,
   kartc_txt_grund,
   kartc_x_artcv_key_fb,
   kartc_x_artcv_key_stat,
   kartc_datum_gueltigab,
   kartc_sernr_ab,
   kartc_abschluss_db_usename
   )
  VALUES
   (
   'EC',          --- k_kba_key
   'R',           --- k_code
   getnumcirclenr('beleg_k__artchange'),        --- k_nummer
   'Test',          --- k_titel
   current_date,        --- k_erfasst_datum
   '#',           --- k_ad_krz
   'param1',          --- x_allgv1
   'P',           --- kartc_x_artcv_key_kategorie
   current_user,        --- kartc_antrag_db_usename
   ks_abt,          --- kartc_antrag_ks_abt
   'EK',          --- kartc_x_artcv_key_abt
   '2',           --- kartc_x_artcv_key_prio
   'Serie',           --- kartc_serie
   'Beschreibungstext',       --- kartc_txt_beschreibung
   'Änderungstext',       --- kartc_txt_grund
   'VERT',          --- kartc_x_artcv_key_fb
   'N',           --- kartc_x_artcv_key_stat
   current_date + 15,         --- kartc_datum_gueltigab
   null,          --- kartc_sernr_ab
   current_user         --- kartc_abschluss_db_usename
  ) RETURNING k_id INTO k_id_;


  p_aknr_ := 'E.B.PKW.A-1168534-0101 /A';
  SELECT ak_bez INTO p_ak_bez_ FROM art WHERE ak_nr = p_aknr_;
  partc_aknr_neu_ := 'E.B.PKW.A-1168534-0102 /A';
  partc_strrevnr_alt_ := 'R1';
  INSERT INTO tartikel.beleg_p__artchange
    (p_k_id, p_erfasst_datum, p_pos, p_apint_db_usename, p_aknr , p_ak_bez , partc_aknr_neu /*, partc_strrevnr_alt*/)
   VALUES
    (k_id_ , current_date   , 10   , current_user      , p_aknr_, p_ak_bez_, partc_aknr_neu_/*, partc_strrevnr_alt_*/);

  p_aknr_ := 'S.W.13.1100001';
  SELECT ak_bez INTO p_ak_bez_ FROM art WHERE ak_nr = p_aknr_;
  partc_aknr_neu_ := null;
  partc_strrevnr_alt_ := 'Aktuell';
  INSERT INTO tartikel.beleg_p__artchange
    (p_k_id, p_erfasst_datum, p_pos, p_apint_db_usename, p_aknr , p_ak_bez , partc_aknr_neu /*, partc_strrevnr_alt*/)
   VALUES
    (k_id_ , current_date   , 20   , current_user      , p_aknr_, p_ak_bez_, partc_aknr_neu_/*, partc_strrevnr_alt_*/);

 END $$;

 --- #12584 Einführung Regalverwaltung
DO $$
 DECLARE  regal VARCHAR := 'R75';
 BEGIN
   INSERT INTO hregal
     (hr_rnr, hr_bez)
   VALUES
     (regal || 'A', 'Testregal Höhe 1'),
     (regal || 'B', 'Testregal Fläche kleiner 4'),
     (regal || 'C', 'Testregal Fläche gut belegt'),
     (regal || 'D', 'Testregal Fläche wenig belegt');

   INSERT INTO regalpos
     (rp_rnr, rp_lae, rp_hoe, rp_pnr, rp_gro, rp_tei, rp_sta, rp_spr)
   VALUES
     (regal || 'A', '01', '01', NULL, 1, 4, 0, false),
     (regal || 'A', '01', '02', NULL, 1, 6, 0, false),
     (regal || 'A', '01', '03', NULL, 1, 8, 0, false),
     (regal || 'B', '01', '01', NULL, 2, 1, 0, false),
     (regal || 'B', '01', '02', NULL, 2, 2, 0, false),
     (regal || 'B', '01', '03', NULL, 2, 3, 0, false),
     (regal || 'C', '01', '01', NULL, 2, 6, 4, false),
     (regal || 'C', '01', '02', NULL, 2, 6, 5, false),
     (regal || 'C', '01', '03', NULL, 2, 6, 6, false),
     (regal || 'D', '01', '01', NULL, 2, 6, 0, false),
     (regal || 'D', '01', '02', NULL, 2, 6, 1, false),
     (regal || 'D', '01', '03', NULL, 2, 6, 2, false);
 END $$;
---

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;